import Point from "./point"
import {delaunay, Triangle} from "delaunayguibasstolfi"
export default class Graph {
    adjList: Map<Point, Array<Point>>;
    constructor() {
      this.adjList = new Map();
    }
    
    addVertex(p: Point): void {
      this.adjList.set(p, new Array<Point>());
    }
  
    addEdge(p1: Point, p2: Point): void {
      if(this.adjList.get(p1).indexOf(p2) < 0 &&
      this.adjList.get(p2).indexOf(p1) < 0){
      this.adjList.get(p1).push(p2);
      }
    }
  
    removeVertex(p: Point): void {
      this.adjList.delete(p);
      for (let [p1, adjVertex] of this.adjList) {
        this.adjList.set(p1, adjVertex.filter(function(p1 : Point){
          return (p1 != p);
        }));
      }
    }
  
    removeEdge(p1: Point, p2: Point): void {
      this.adjList.set(p1, this.adjList.get(p1).filter(function(p : Point){
        return (p2 != p);
      }));
      this.adjList.set(p2, this.adjList.get(p2).filter(function(p : Point){
        return (p1 != p);
      }));
    }
  
    toString() {
      let graphString: string = "";
      let formatMap :Map<Point, number> = new Map();
      
      let i = 0;
      for(let vertex of this.adjList.keys()){
        formatMap.set(vertex, i);
        graphString += i + ": " + vertex.toString() + "\n";
        i++;
      }

      graphString += "#" + "\n";

      for (let [vertex, adjList] of this.adjList) {
        for (let adjVertex of adjList) {
            graphString += formatMap.get(adjVertex) + " " + formatMap.get(vertex) + "\n";
          }
      }
      return graphString;
    }

    createDelaunayTriangulation(){
        let arrVertex = [];
        let graphDelaunay = new Graph();
        for (let point of this.adjList.keys()) {
          arrVertex.push(point);
          graphDelaunay.addVertex(point);
        }
        arrVertex.sort(function (a, b) {if (a.x == b.x) return a.y - b.y; else return a.x - b.x;});
      
        let arrTriangle = delaunay(arrVertex);
        for (let triangle of arrTriangle) {

          let a = new Point(triangle.a.x, triangle.a.y);
          let b = new Point(triangle.b.x, triangle.b.y);
          let c = new Point(triangle.c.x, triangle.c.y);
      
          for(let vertex of arrVertex){
            if(vertex.x == a.x && vertex.y == a.y){
              a = vertex;
            }
            if(vertex.x == b.x && vertex.y == b.y){
              b = vertex;
            }
            if(vertex.x == c.x && vertex.y == c.y){
              c = vertex;
            }
          }
          graphDelaunay.addEdge(a, b);
          graphDelaunay.addEdge(b, c);
          graphDelaunay.addEdge(a, c);
      }
      return graphDelaunay;
    }
}
  